/*
"Perl code to convert this to a skinvalues.txt file.";
print "title Generic\n";
print "author Morphed\n";
print "\n";
while(<DATA>)
{
	chomp;
	if(/^\s*(?:SKINFLOAT|SKINVECTOR)\(([A-Z_]+), ([-'0-9. ]+)\);$/) #'
	{
		printf "%-31s %s\n", $1, $2;
	}
	elsif(/^\s*SKINSTRING\(([A-Z_]+), "(.*)"\);$/)
	{
		# printf "//   uses \"$2\" images\n";
		printf "%-31s %s\n", $1, $2;
	}
	elsif(/^$/)
	{
		print "\n";
	}
	elsif(/^\s+\/\/ (.*)$/)
	{
		print "// $1\n";
	}
	elsif(/^SKINBEGIN$|^SKINEND$|^#endif$/)
	{
	}
	else
	{
		print "!!! $_\n";
	}
}
__DATA__
*/
SKINBEGIN
	// font sizes (used for everything)
	SKINFLOAT(FONTSIZE_NORMAL, 12);
	SKINFLOAT(HEIGHT_NORMAL, 1.5);
	SKINFLOAT(FONTSIZE_TITLE, 16);
	SKINFLOAT(HEIGHT_TITLE, 1.5);
	SKINFLOAT(HEIGHT_ZOOMEDTITLE, -1);

	// tooltips
	SKINSTRING(GFX_TOOLTIP, "tooltip");
	SKINVECTOR(MARGIN_TOOLTIP, '5 5 0');
	SKINVECTOR(BORDER_TOOLTIP, '1 1 0');
	SKINVECTOR(AVOID_TOOLTIP, '8 8 0');
	SKINFLOAT(WIDTH_TOOLTIP, 0.3);
	SKINFLOAT(FONTSIZE_TOOLTIP, 12);
	SKINFLOAT(ALPHA_TOOLTIP, 0.7);
	SKINVECTOR(COLOR_TOOLTIP, '1 1 1');

	// the individual dialog background colors
	SKINVECTOR(COLOR_DIALOG_FIRSTRUN, '0.7 0.7 1');
	SKINVECTOR(COLOR_DIALOG_MULTIPLAYER, '0.7 0.7 1');
	SKINVECTOR(COLOR_DIALOG_SETTINGS, '0.7 0.7 1');
	SKINVECTOR(COLOR_DIALOG_TEAMSELECT, '1 1 1');
	SKINVECTOR(COLOR_DIALOG_SANDBOXTOOLS, '1 1 1');
	SKINVECTOR(COLOR_DIALOG_QUIT, '1 0 0');
	SKINVECTOR(COLOR_DIALOG_ADVANCED, '0.7 0.7 1');
	SKINVECTOR(COLOR_DIALOG_MUTATORS, '0.7 0.7 1');
	SKINVECTOR(COLOR_DIALOG_MAPINFO, '0.7 0.7 1');
	SKINVECTOR(COLOR_DIALOG_MEDIA, '0.7 0.7 1');
	SKINVECTOR(COLOR_DIALOG_USERBIND, '0.7 0.7 1');
	SKINVECTOR(COLOR_DIALOG_SINGLEPLAYER, '1 1 0.7');
	SKINVECTOR(COLOR_DIALOG_CREDITS, '0.7 0.7 1');
	SKINVECTOR(COLOR_DIALOG_WEAPONS, '1 0.7 0.7');
	SKINVECTOR(COLOR_DIALOG_VIEW, '1 0.7 0.7');
	SKINVECTOR(COLOR_DIALOG_MODEL, '1 0.7 0.7');
	SKINVECTOR(COLOR_DIALOG_CROSSHAIR, '1 0.7 0.7');
	SKINVECTOR(COLOR_DIALOG_HUD, '1 0.7 0.7');
	SKINVECTOR(COLOR_DIALOG_SERVERINFO, '0.7 0.7 1');
	SKINVECTOR(COLOR_DIALOG_WELCOME, '1 0.7 0.7');
	SKINVECTOR(COLOR_DIALOG_CVARS, '1 0 0');
	SKINVECTOR(COLOR_DIALOG_SCREENSHOTVIEWER, '0.7 0.7 1');
	SKINVECTOR(COLOR_DIALOG_HUDCONFIRM, '1 0 0');

	// nexposee positions of windows (they are the scale transformation
	// centers, NOT the actual positions of the windows!)
	SKINVECTOR(POSITION_DIALOG_MULTIPLAYER, '0.9 0.5 0');
	SKINVECTOR(POSITION_DIALOG_SINGLEPLAYER, '0.1 0.1 0');
	SKINVECTOR(POSITION_DIALOG_MEDIA, '0.9 0.9 0');
	SKINVECTOR(POSITION_DIALOG_SETTINGS, '0.1 0.9 0');
	SKINVECTOR(POSITION_DIALOG_CREDITS, '0.3 1.2 0');
	SKINVECTOR(POSITION_DIALOG_QUIT, '0.9 1.2 0');

	// mouse
	SKINSTRING(GFX_CURSOR, "cursor");
	SKINVECTOR(SIZE_CURSOR, '32 32 0');
	SKINVECTOR(OFFSET_CURSOR, '0 0 0');
	SKINFLOAT(ALPHA_CURSOR_INTRO, 0);

	// general
	SKINVECTOR(COLOR_BACKGROUND, '0 0 0');
	SKINSTRING(GFX_BACKGROUND, "background");
	SKINSTRING(GFX_BACKGROUND_INGAME, "background_ingame");
	// alignment string of num keys for orientations, or l = letterbox, c = crop, h = height, w = width, s = scale
	SKINSTRING(ALIGN_BACKGROUND, "5");
	SKINSTRING(ALIGN_BACKGROUND_INGAME, "5");
	SKINFLOAT(ALPHA_BACKGROUND_INGAME, 0.7);
	SKINFLOAT(ALPHA_DISABLED, 0.2);
	SKINFLOAT(ALPHA_BEHIND, 0.5);
	SKINFLOAT(ALPHA_TEXT, 0.7);
	SKINVECTOR(COLOR_TEXT, '1 1 1');
	SKINFLOAT(ALPHA_HEADER, 0.5);
	SKINVECTOR(COLOR_HEADER, '1 1 1');

	// item: button
	SKINSTRING(GFX_BUTTON, "button");
	SKINSTRING(GFX_BUTTON_GRAY, "buttongray");
	SKINSTRING(GFX_BUTTON_BIG, "bigbutton");
	SKINSTRING(GFX_BUTTON_BIG_GRAY, "bigbuttongray");
	SKINVECTOR(COLOR_BUTTON_N, '1 1 1');
	SKINVECTOR(COLOR_BUTTON_C, '1 1 1');
	SKINVECTOR(COLOR_BUTTON_F, '1 1 1');
	SKINVECTOR(COLOR_BUTTON_D, '1 1 1');
	SKINFLOAT(MARGIN_BUTTON, 0.5);

	// item: campaign
	SKINFLOAT(ALPHA_CAMPAIGN_SELECTABLE, 0.8);
	SKINVECTOR(COLOR_CAMPAIGN_SELECTABLE, '1 1 1');
	SKINFLOAT(ALPHA_CAMPAIGN_CURRENT, 1);
	SKINVECTOR(COLOR_CAMPAIGN_CURRENT, '1 1 0');
	SKINFLOAT(ALPHA_CAMPAIGN_FUTURE, 0.2);
	SKINVECTOR(COLOR_CAMPAIGN_FUTURE, '1 1 1');
	SKINFLOAT(ALPHA_CAMPAIGN_DESCRIPTION, 0.7);

	// item: checkbox
	SKINSTRING(GFX_CHECKBOX, "checkbox");
	SKINVECTOR(COLOR_CHECKBOX_N, '1 1 1');
	SKINVECTOR(COLOR_CHECKBOX_C, '1 1 1');
	SKINVECTOR(COLOR_CHECKBOX_F, '1 1 1');
	SKINVECTOR(COLOR_CHECKBOX_D, '1 1 1');

	// item: color picker
	SKINSTRING(GFX_COLORPICKER, "colorpicker");
	SKINVECTOR(MARGIN_COLORPICKER, '0 0 0');

	// item: credits list
	SKINVECTOR(COLOR_CREDITS_TITLE, '1 1 1');
	SKINFLOAT(ALPHA_CREDITS_TITLE, 1);
	SKINVECTOR(COLOR_CREDITS_FUNCTION, '1 1 1');
	SKINFLOAT(ALPHA_CREDITS_FUNCTION, 0.7);
	SKINVECTOR(COLOR_CREDITS_PERSON, '0.7 0.7 1');
	SKINFLOAT(ALPHA_CREDITS_PERSON, 0.7);
	SKINFLOAT(ROWS_CREDITS, 20);
	SKINFLOAT(WIDTH_CREDITS, 0.5);

	// item: cvar list
	SKINFLOAT(ALPHA_CVARLIST_SAVED, 1);
	SKINFLOAT(ALPHA_CVARLIST_TEMPORARY, 0.7);
	SKINVECTOR(COLOR_CVARLIST_CHANGED, '1 1 0.4');
	SKINVECTOR(COLOR_CVARLIST_UNCHANGED, '1 1 1');
	SKINVECTOR(COLOR_CVARLIST_CONTROLS, '1 0 0');

	// item: dialog
	SKINSTRING(GFX_DIALOGBORDER, "border");
	SKINSTRING(GFX_CLOSEBUTTON, "closebutton");
	SKINFLOAT(MARGIN_TOP, 8);
	SKINFLOAT(MARGIN_BOTTOM, 8);
	SKINFLOAT(MARGIN_LEFT, 8);
	SKINFLOAT(MARGIN_RIGHT, 8);
	SKINFLOAT(MARGIN_COLUMNS, 4);
	SKINFLOAT(MARGIN_ROWS, 4);
	SKINFLOAT(HEIGHT_DIALOGBORDER, 1);

	// item: input box
	SKINSTRING(GFX_INPUTBOX, "inputbox");
	SKINVECTOR(COLOR_INPUTBOX_N, '1 1 1');
	SKINVECTOR(COLOR_INPUTBOX_F, '1 1 1');
	SKINFLOAT(MARGIN_INPUTBOX_CHARS, 1);

	// item: clear button
	SKINSTRING(GFX_CLEARBUTTON, "clearbutton");
	SKINFLOAT(OFFSET_CLEARBUTTON, 0);
	SKINVECTOR(COLOR_CLEARBUTTON_N, '1 1 1');
	SKINVECTOR(COLOR_CLEARBUTTON_F, '1 1 1');
	SKINVECTOR(COLOR_CLEARBUTTON_C, '1 1 1');

	// item: gametype list
	SKINFLOAT(BOOL_GAMETYPELIST_ICON_BLUR, 1);

	// item: key grabber
	SKINVECTOR(COLOR_KEYGRABBER_TITLES, '1 1 1');
	SKINFLOAT(ALPHA_KEYGRABBER_TITLES, 1);
	SKINVECTOR(COLOR_KEYGRABBER_KEYS, '1 1 1');
	SKINFLOAT(ALPHA_KEYGRABBER_KEYS, 0.7);
	SKINVECTOR(COLOR_KEYGRABBER_KEYS_IMMUTABLE, '0.5 0.5 0.5');
	SKINFLOAT(ALPHA_KEYGRABBER_KEYS_IMMUTABLE, 0.7);

	// item: list box
	SKINVECTOR(COLOR_LISTBOX_SELECTED, '0 0 1');
	SKINFLOAT(ALPHA_LISTBOX_SELECTED, 0.5);
	SKINVECTOR(COLOR_LISTBOX_WAITING, '1 0 0');
	SKINFLOAT(ALPHA_LISTBOX_WAITING, 0.5);
	SKINVECTOR(COLOR_LISTBOX_BACKGROUND, '0 0 0');
	SKINFLOAT(ALPHA_LISTBOX_BACKGROUND, 0.5);
	SKINVECTOR(COLOR_LISTBOX_FOCUSED, '0 0 1');
	SKINFLOAT(ALPHA_LISTBOX_FOCUSED, 0.7);
	SKINFLOAT(FADEALPHA_LISTBOX_FOCUSED, 0.3);

	// item: map list
	SKINVECTOR(COLOR_MAPLIST_TITLE, '1 1 1');
	SKINVECTOR(COLOR_MAPLIST_AUTHOR, '0.4 0.4 0.7');
	SKINVECTOR(COLOR_MAPLIST_INCLUDEDBG, '0 0 0');
	SKINFLOAT(ALPHA_MAPLIST_INCLUDEDFG, 1);
	SKINFLOAT(ALPHA_MAPLIST_INCLUDEDBG, 0.5);
	SKINFLOAT(ALPHA_MAPLIST_NOTINCLUDEDFG, 0.4);

	// item: nexposee
	SKINVECTOR(ALPHAS_MAINMENU, '0.6 0.8 0.9');
	SKINFLOAT(ALPHA_DIALOG_SANDBOXTOOLS, 0.6);

	// item: player color button
	SKINSTRING(GFX_COLORBUTTON, "colorbutton");

	// item: player model
	SKINVECTOR(COLOR_MODELTITLE, '1 1 1');
	SKINFLOAT(ALPHA_MODELTITLE, 1);

	// item: special character picker
	SKINVECTOR(COLOR_CHARMAP_CHAR, '1 1 1');
	SKINFLOAT(ALPHA_CHARMAP_CHAR, 1);

	// item: crosshair picker
	SKINVECTOR(COLOR_CROSSHAIRPICKER_CROSSHAIR, '1 1 1');
	SKINFLOAT(ALPHA_CROSSHAIRPICKER_CROSSHAIR, 1);

	// item: radio button
	SKINSTRING(GFX_RADIOBUTTON, "radiobutton");
	SKINVECTOR(COLOR_RADIOBUTTON_N, '1 1 1');
	SKINVECTOR(COLOR_RADIOBUTTON_C, '1 1 1');
	SKINVECTOR(COLOR_RADIOBUTTON_F, '1 1 1');
	SKINVECTOR(COLOR_RADIOBUTTON_D, '1 1 1');

	// item: scrollbar
	SKINSTRING(GFX_SCROLLBAR, "scrollbar");
	SKINVECTOR(COLOR_SCROLLBAR_N, '1 1 1');
	SKINVECTOR(COLOR_SCROLLBAR_F, '1 1 1');
	SKINVECTOR(COLOR_SCROLLBAR_C, '1 1 1');
	SKINVECTOR(COLOR_SCROLLBAR_S, '1 1 1');
	SKINFLOAT(WIDTH_SCROLLBAR, 16);

	// item: server list
	SKINFLOAT(ALPHA_SERVERLIST_CATEGORY, 0.7);
	SKINVECTOR(COLOR_SERVERLIST_CATEGORY, '1 1 1');
	SKINFLOAT(ALPHA_SERVERLIST_FULL, 0.4);
	SKINFLOAT(ALPHA_SERVERLIST_EMPTY, 0.7);
	SKINVECTOR(COLOR_SERVERLIST_LOWPING, '0 1 0');
	SKINVECTOR(COLOR_SERVERLIST_MEDPING, '1 1 0');
	SKINVECTOR(COLOR_SERVERLIST_HIGHPING, '1 0 0');
	SKINFLOAT(ALPHA_SERVERLIST_HIGHPING, 0.4);
	SKINFLOAT(ALPHA_SERVERLIST_FAVORITE, 0.8);
	SKINVECTOR(COLOR_SERVERLIST_FAVORITE, '1 1 1');
	SKINFLOAT(ALPHA_SERVERLIST_IMPOSSIBLE, 0.7);
	SKINVECTOR(COLOR_SERVERLIST_IMPOSSIBLE, '0.3 0.3 0.3');
	SKINFLOAT(ALPHA_SERVERLIST_ICON_NONPURE, 0.5);

	// item: server info
	SKINVECTOR(COLOR_SERVERINFO_NAME, '1 1 1');
	SKINVECTOR(COLOR_SERVERINFO_IP, '0.4 0.4 0.7');

	// item: skin list
	SKINVECTOR(COLOR_SKINLIST_TITLE, '1 1 1');
	SKINVECTOR(COLOR_SKINLIST_AUTHOR, '0.4 0.4 0.7');

	// item: demo list
	SKINVECTOR(COLOR_DEMOLIST_SUBDIR, '0.5 0.5 0.5');

	// item: screenshot list
	SKINVECTOR(COLOR_SCREENSHOTLIST_SUBDIR, '0.5 0.5 0.5');

	// item: slider
	SKINSTRING(GFX_SLIDER, "slider");
	SKINVECTOR(COLOR_SLIDER_N, '1 1 1');
	SKINVECTOR(COLOR_SLIDER_C, '1 1 1');
	SKINVECTOR(COLOR_SLIDER_F, '1 1 1');
	SKINVECTOR(COLOR_SLIDER_D, '1 1 1');
	SKINVECTOR(COLOR_SLIDER_S, '1 1 1');
	SKINFLOAT(WIDTH_SLIDERTEXT, 0.333333333333);
SKINEND
