#ifndef R_STATS_H
#define R_STATS_H

extern const char *r_stat_name[];

// NOTE: r_stat_name[] must match this indexing
typedef enum r_stat_e
{
	r_stat_timedelta,
	r_stat_quality,
	r_stat_renders,
	r_stat_entities,
	r_stat_entities_surfaces,
	r_stat_entities_triangles,
	r_stat_world_leafs,
	r_stat_world_portals,
	r_stat_world_surfaces,
	r_stat_world_triangles,
	r_stat_lightmapupdates,
	r_stat_lightmapupdatepixels,
	r_stat_particles,
	r_stat_drawndecals,
	r_stat_totaldecals,
	r_stat_draws,
	r_stat_draws_vertices,
	r_stat_draws_elements,
	r_stat_lights,
	r_stat_lights_clears,
	r_stat_lights_scissored,
	r_stat_lights_lighttriangles,
	r_stat_lights_shadowtriangles,
	r_stat_lights_dynamicshadowtriangles,
	r_stat_bouncegrid_lights,
	r_stat_bouncegrid_particles,
	r_stat_bouncegrid_traces,
	r_stat_bouncegrid_hits,
	r_stat_bouncegrid_splats,
	r_stat_bouncegrid_bounces,
	r_stat_photoncache_animated,
	r_stat_photoncache_cached,
	r_stat_photoncache_traced,
	r_stat_bloom,
	r_stat_bloom_copypixels,
	r_stat_bloom_drawpixels,
	r_stat_rendertargets_used,
	r_stat_rendertargets_pixels,
	r_stat_indexbufferuploadcount,
	r_stat_indexbufferuploadsize,
	r_stat_vertexbufferuploadcount,
	r_stat_vertexbufferuploadsize,
	r_stat_framedatacurrent,
	r_stat_framedatasize,
	r_stat_bufferdatacurrent_vertex, // R_BUFFERDATA_ types are added to this index
	r_stat_bufferdatacurrent_index16,
	r_stat_bufferdatacurrent_index32,
	r_stat_bufferdatacurrent_uniform,
	r_stat_bufferdatasize_vertex, // R_BUFFERDATA_ types are added to this index
	r_stat_bufferdatasize_index16,
	r_stat_bufferdatasize_index32,
	r_stat_bufferdatasize_uniform,
	r_stat_animcache_skeletal_count,
	r_stat_animcache_skeletal_bones,
	r_stat_animcache_skeletal_maxbones,
	r_stat_animcache_shade_count,
	r_stat_animcache_shade_vertices,
	r_stat_animcache_shade_maxvertices,
	r_stat_animcache_shape_count,
	r_stat_animcache_shape_vertices,
	r_stat_animcache_shape_maxvertices,
	r_stat_batch_batches,
	r_stat_batch_withgaps,
	r_stat_batch_surfaces,
	r_stat_batch_vertices,
	r_stat_batch_triangles,
	r_stat_batch_fast_batches,
	r_stat_batch_fast_surfaces,
	r_stat_batch_fast_vertices,
	r_stat_batch_fast_triangles,
	r_stat_batch_copytriangles_batches,
	r_stat_batch_copytriangles_surfaces,
	r_stat_batch_copytriangles_vertices,
	r_stat_batch_copytriangles_triangles,
	r_stat_batch_dynamic_batches,
	r_stat_batch_dynamic_surfaces,
	r_stat_batch_dynamic_vertices,
	r_stat_batch_dynamic_triangles,
	r_stat_batch_dynamicskeletal_batches,
	r_stat_batch_dynamicskeletal_surfaces,
	r_stat_batch_dynamicskeletal_vertices,
	r_stat_batch_dynamicskeletal_triangles,
	r_stat_batch_dynamic_batches_because_cvar,
	r_stat_batch_dynamic_surfaces_because_cvar,
	r_stat_batch_dynamic_vertices_because_cvar,
	r_stat_batch_dynamic_triangles_because_cvar,
	r_stat_batch_dynamic_batches_because_lightmapvertex,
	r_stat_batch_dynamic_surfaces_because_lightmapvertex,
	r_stat_batch_dynamic_vertices_because_lightmapvertex,
	r_stat_batch_dynamic_triangles_because_lightmapvertex,
	r_stat_batch_dynamic_batches_because_deformvertexes_autosprite,
	r_stat_batch_dynamic_surfaces_because_deformvertexes_autosprite,
	r_stat_batch_dynamic_vertices_because_deformvertexes_autosprite,
	r_stat_batch_dynamic_triangles_because_deformvertexes_autosprite,
	r_stat_batch_dynamic_batches_because_deformvertexes_autosprite2,
	r_stat_batch_dynamic_surfaces_because_deformvertexes_autosprite2,
	r_stat_batch_dynamic_vertices_because_deformvertexes_autosprite2,
	r_stat_batch_dynamic_triangles_because_deformvertexes_autosprite2,
	r_stat_batch_dynamic_batches_because_deformvertexes_normal,
	r_stat_batch_dynamic_surfaces_because_deformvertexes_normal,
	r_stat_batch_dynamic_vertices_because_deformvertexes_normal,
	r_stat_batch_dynamic_triangles_because_deformvertexes_normal,
	r_stat_batch_dynamic_batches_because_deformvertexes_wave,
	r_stat_batch_dynamic_surfaces_because_deformvertexes_wave,
	r_stat_batch_dynamic_vertices_because_deformvertexes_wave,
	r_stat_batch_dynamic_triangles_because_deformvertexes_wave,
	r_stat_batch_dynamic_batches_because_deformvertexes_bulge,
	r_stat_batch_dynamic_surfaces_because_deformvertexes_bulge,
	r_stat_batch_dynamic_vertices_because_deformvertexes_bulge,
	r_stat_batch_dynamic_triangles_because_deformvertexes_bulge,
	r_stat_batch_dynamic_batches_because_deformvertexes_move,
	r_stat_batch_dynamic_surfaces_because_deformvertexes_move,
	r_stat_batch_dynamic_vertices_because_deformvertexes_move,
	r_stat_batch_dynamic_triangles_because_deformvertexes_move,
	r_stat_batch_dynamic_batches_because_tcgen_lightmap,
	r_stat_batch_dynamic_surfaces_because_tcgen_lightmap,
	r_stat_batch_dynamic_vertices_because_tcgen_lightmap,
	r_stat_batch_dynamic_triangles_because_tcgen_lightmap,
	r_stat_batch_dynamic_batches_because_tcgen_vector,
	r_stat_batch_dynamic_surfaces_because_tcgen_vector,
	r_stat_batch_dynamic_vertices_because_tcgen_vector,
	r_stat_batch_dynamic_triangles_because_tcgen_vector,
	r_stat_batch_dynamic_batches_because_tcgen_environment,
	r_stat_batch_dynamic_surfaces_because_tcgen_environment,
	r_stat_batch_dynamic_vertices_because_tcgen_environment,
	r_stat_batch_dynamic_triangles_because_tcgen_environment,
	r_stat_batch_dynamic_batches_because_tcmod_turbulent,
	r_stat_batch_dynamic_surfaces_because_tcmod_turbulent,
	r_stat_batch_dynamic_vertices_because_tcmod_turbulent,
	r_stat_batch_dynamic_triangles_because_tcmod_turbulent,
	r_stat_batch_dynamic_batches_because_nogaps,
	r_stat_batch_dynamic_surfaces_because_nogaps,
	r_stat_batch_dynamic_vertices_because_nogaps,
	r_stat_batch_dynamic_triangles_because_nogaps,
	r_stat_batch_dynamic_batches_because_derived,
	r_stat_batch_dynamic_surfaces_because_derived,
	r_stat_batch_dynamic_vertices_because_derived,
	r_stat_batch_dynamic_triangles_because_derived,
	r_stat_batch_entitycache_count,
	r_stat_batch_entitycache_surfaces,
	r_stat_batch_entitycache_vertices,
	r_stat_batch_entitycache_triangles,
	r_stat_batch_entityanimate_count,
	r_stat_batch_entityanimate_surfaces,
	r_stat_batch_entityanimate_vertices,
	r_stat_batch_entityanimate_triangles,
	r_stat_batch_entityskeletal_count,
	r_stat_batch_entityskeletal_surfaces,
	r_stat_batch_entityskeletal_vertices,
	r_stat_batch_entityskeletal_triangles,
	r_stat_batch_entitystatic_count,
	r_stat_batch_entitystatic_surfaces,
	r_stat_batch_entitystatic_vertices,
	r_stat_batch_entitystatic_triangles,
	r_stat_batch_entitycustom_count,
	r_stat_batch_entitycustom_surfaces,
	r_stat_batch_entitycustom_vertices,
	r_stat_batch_entitycustom_triangles,
	r_stat_count // size of array
}
r_stat_t;

extern cvar_t r_speeds_graph;
extern cvar_t r_speeds_graph_filter[8];
extern cvar_t r_speeds_graph_length;
extern cvar_t r_speeds_graph_seconds;
extern cvar_t r_speeds_graph_x;
extern cvar_t r_speeds_graph_y;
extern cvar_t r_speeds_graph_width;
extern cvar_t r_speeds_graph_height;
extern cvar_t r_speeds_graph_maxtimedelta;
extern cvar_t r_speeds_graph_maxdefault;

void R_TimeReport(const char *name);
void R_TimeReport_BeginFrame(void);
void R_TimeReport_EndFrame(void);

#endif
